<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Soap\ExtSoapEngine\Configuration\ClassMap;

/**
 * @implements \IteratorAggregate<string, ClassMapInterface>
 */
final class ClassMapCollection implements \IteratorAggregate
{
    /**
     * @var array<string, ClassMapInterface>
     */
    private $classMaps = [];

    public function __construct(ClassMapInterface ...$classMaps)
    {
        foreach ($classMaps as $classMap) {
            $this->classMaps[$classMap->getWsdlType()] = $classMap;
        }
    }

    public function set(ClassMapInterface $classMap): self
    {
        $this->classMaps[$classMap->getWsdlType()] = $classMap;

        return $this;
    }

    /**
     * @return \Iterator<string, ClassMap>
     */
    public function getIterator(): \Iterator
    {
        return new \ArrayIterator($this->classMaps);
    }
}
