<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Gls\GlsPoland\Entity\Carrier;

/**
 * @extends ServiceEntityRepository<Carrier>
 *
 * @method Carrier|null find($id, $lockMode = null, $lockVersion = null)
 * @method Carrier|null findOneBy(array $criteria, array $orderBy = null)
 * @method Carrier[] findAll()
 * @method Carrier[] findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class CarrierRepository extends EntityRepository
{
    public function add(Carrier $entity, bool $flush = true): void
    {
        $entityManager = $this->getEntityManager();
        $entityManager->persist($entity);
        if ($flush) {
            $entityManager->flush();
        }
    }

    public function remove(Carrier $entity, bool $flush = true): void
    {
        $entityManager = $this->getEntityManager();
        $entityManager->remove($entity);
        if ($flush) {
            $entityManager->flush();
        }
    }

    protected static function getEntityClass(): string
    {
        return Carrier::class;
    }
}
