<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Installer\Migration;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\DBAL\Schema\Table;

final class Version1_0_0 extends AbstractMigration
{
    private const CARRIER_TABLE = 'gls_poland_carrier';
    private const CONSIGNMENT_TABLE = 'gls_poland_consignment';
    private const PARCEL_TABLE = 'gls_poland_parcel';
    private const CHECKOUT_SESSION_TABLE = 'gls_poland_checkout_session';

    public function getVersion(): string
    {
        return '1.0.0';
    }

    public function up(Schema $schema): void
    {
        $this->configureCarrierTable($this->createTable($schema, self::CARRIER_TABLE));
        $this->configureConsignmentTable($this->createTable($schema, self::CONSIGNMENT_TABLE));
        $this->configureParcelTable($this->createTable($schema, self::PARCEL_TABLE));
        $this->configureCheckoutSessionTable($this->createTable($schema, self::CHECKOUT_SESSION_TABLE));
    }

    public function down(Schema $schema): void
    {
        $this->dropTable($schema, self::PARCEL_TABLE);
        $this->dropTable($schema, self::CONSIGNMENT_TABLE);
        $this->dropTable($schema, self::CARRIER_TABLE);
        $this->dropTable($schema, self::CHECKOUT_SESSION_TABLE);
    }

    private function configureCarrierTable(Table $table): void
    {
        $this->addColumn($table, 'id_reference', 'integer')->setLength(10)->setUnsigned(true);
        $this->addColumn($table, 'type', 'string')->setLength(32);
        $this->addColumn($table, 'countries', 'simple_array')->setLength(65535);
        $this->addColumn($table, 'cash_on_delivery', 'boolean')->setNotnull(false);
        $this->addColumn($table, 'saturday_delivery', 'boolean')->setNotnull(false);
        $this->addColumn($table, 'delivery_before_10', 'boolean')->setNotnull(false);
        $this->addColumn($table, 'delivery_before_12', 'boolean')->setNotnull(false);
        $this->addColumn($table, 'document_return', 'boolean')->setNotnull(false);
        $this->setPrimaryKey($table, ['id_reference']);
    }

    private function configureConsignmentTable(Table $table): void
    {
        $this->addColumn($table, 'id', 'integer')->setAutoincrement(true);
        $this->addColumn($table, 'prep_box_id', 'integer');
        $this->addColumn($table, 'id_order', 'integer')->setLength(10)->setUnsigned(true);
        $this->addColumn($table, 'pickup_id', 'integer')->setNotnull(false);
        $this->addColumn($table, 'consignment_id', 'integer')->setNotnull(false);
        $this->addColumn($table, 'sandbox', 'boolean');
        $this->addColumn($table, 'reference', 'string')->setLength(25)->setNotnull(false);
        $this->addColumn($table, 'email', 'string')->setLength(40)->setNotnull(false);
        $this->addColumn($table, 'phone', 'string')->setLength(40)->setNotnull(false);
        $this->addColumn($table, 'created_at', 'datetime_immutable');
        $this->setPrimaryKey($table, ['id']);
        $table->addForeignKeyConstraint($this->prefixTableName('orders'), ['id_order'], ['id_order'], [
            'onDelete' => 'CASCADE',
        ]);
    }

    private function configureParcelTable(Table $table): void
    {
        $this->addColumn($table, 'id', 'integer')->setAutoincrement(true);
        $this->addColumn($table, 'consignment_id', 'integer');
        $this->addColumn($table, 'weight', 'float');
        $this->addColumn($table, 'reference', 'string')->setLength(25)->setNotnull(false);
        $this->addColumn($table, 'number', 'string')->setLength(11)->setNotnull(false);
        $this->setPrimaryKey($table, ['id']);
        $table->addForeignKeyConstraint($this->prefixTableName(self::CONSIGNMENT_TABLE), ['consignment_id'], ['id'], [
            'onDelete' => 'CASCADE',
        ]);
    }

    private function configureCheckoutSessionTable(Table $table): void
    {
        $this->addColumn($table, 'id_cart', 'integer')->setLength(10)->setUnsigned(true);
        $this->addColumn($table, 'parcel_shops', 'json');
        $this->setPrimaryKey($table, ['id_cart']);
        $table->addForeignKeyConstraint($this->prefixTableName('cart'), ['id_cart'], ['id_cart'], [
            'onDelete' => 'CASCADE',
        ]);
    }
}
