<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Hook\Admin\Legacy;

use Gls\GlsPoland\Controller\Admin\ConsignmentController;
use PrestaShopBundle\Security\Voter\PageVoter;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;
use Twig\Environment;

final class DisplayAdminOrderTabShip extends AbstractLegacyOrdersPageHook
{
    public const HOOK_NAME = 'displayAdminOrderTabShip';

    private $authorizationChecker;
    private $twig;

    public function __construct(AuthorizationCheckerInterface $authorizationChecker, Environment $twig)
    {
        $this->authorizationChecker = $authorizationChecker;
        $this->twig = $twig;
    }

    public function execute(array $parameters): string
    {
        if (!$this->authorizationChecker->isGranted(PageVoter::READ, ConsignmentController::TAB_NAME)) {
            return '';
        }

        return $this->twig->render('@Modules/glspoland/views/templates/hook/legacy/admin_order_tab_ship.html.twig');
    }
}
