<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Checkout\Message;

final class UpdateParcelShopChoiceCommand
{
    /**
     * @var \Cart
     */
    private $cart;

    /**
     * @var string
     */
    private $parcelShopId;

    public function __construct(\Cart $cart, string $parcelShopId)
    {
        $this->cart = $cart;
        $this->parcelShopId = $parcelShopId;
    }

    public function getCart(): \Cart
    {
        return $this->cart;
    }

    public function getParcelShopId(): string
    {
        return $this->parcelShopId;
    }
}
