<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use Gls\GlsPoland\Carrier\CarrierType;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class CarrierTypeChoiceType extends AbstractType
{
    use TranslatorAwareTrait;

    public function getParent(): string
    {
        return ChoiceType::class;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setDefaults([
                'choices' => [
                    $this->getTranslator()->trans('Courier', [], 'Modules.Glspoland.Carrier') => CarrierType::COURIER,
                    $this->getTranslator()->trans('Parcel shop delivery', [], 'Modules.Glspoland.Carrier') => CarrierType::SHOP_DELIVERY,
                ],
            ]);
    }
}
