<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use Gls\GlsPoland\Consignment\DTO\AddressDetails;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use PrestaShop\PrestaShop\Core\Form\ChoiceProvider\CountryByIsoCodeChoiceProvider;
use PrestaShop\PrestaShop\Core\Form\FormChoiceProviderInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\ChoiceList\Loader\CallbackChoiceLoader;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraint;

final class AddressDetailsType extends AbstractType
{
    use TranslatorAwareTrait;

    private $countryChoiceProvider;

    /**
     * @param CountryByIsoCodeChoiceProvider $countryChoiceProvider
     */
    public function __construct(FormChoiceProviderInterface $countryChoiceProvider)
    {
        $this->countryChoiceProvider = $countryChoiceProvider;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('name1', TextType::class, [
                'label' => $this->getTranslator()->trans('Name', [], 'Modules.Glspoland.Address'),
            ])
            ->add('name2', TextType::class, [
                'required' => false,
                'label' => $this->getTranslator()->trans('Name (2)', [], 'Modules.Glspoland.Address'),
            ])
            ->add('name3', TextType::class, [
                'required' => false,
                'label' => $this->getTranslator()->trans('Name (3)', [], 'Modules.Glspoland.Address'),
            ])
            ->add('street', TextType::class, [
                'label' => $this->getTranslator()->trans('Street', [], 'Admin.Global'),
            ])
            ->add('zipCode', TextType::class, [
                'label' => $this->getTranslator()->trans('Zip/Postal code', [], 'Admin.Global'),
                'attr' => [
                    'class' => 'js-zip-code-input',
                ],
            ])
            ->add('city', TextType::class, [
                'label' => $this->getTranslator()->trans('City', [], 'Admin.Global'),
            ])
            ->add('countryIsoCode', ChoiceType::class, [
                'choice_loader' => new CallbackChoiceLoader([$this->countryChoiceProvider, 'getChoices']),
                'label' => $this->getTranslator()->trans('Country', [], 'Admin.Global'),
                'attr' => [
                    'class' => 'js-country-choice',
                    'data-toggle' => 'select2',
                    'data-minimumResultsForSearch' => 7,
                ],
            ])
            ->add('email', EmailType::class, [
                'required' => false,
                'label' => $this->getTranslator()->trans('Email', [], 'Admin.Global'),
            ])
            ->add('phone', TextType::class, [
                'required' => false,
                'label' => $this->getTranslator()->trans('Phone', [], 'Admin.Global'),
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setDefaults([
                'data_class' => AddressDetails::class,
                'validation_groups' => [Constraint::DEFAULT_GROUP, AddressDetails::OTHER_ADDRESS_VALIDATION_GROUP],
            ]);
    }
}
