<?php

declare(strict_types=1);

namespace Gls\GlsPoland\EventDispatcher;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;

interface EventDispatcherInterface
{
    /**
     * @template T of object $event
     *
     * @param T $event
     *
     * @return T
     */
    public function dispatch(object $event, ?string $eventName = null);

    public function addSubscriber(EventSubscriberInterface $subscriber);
}
