<?php

namespace Gls\GlsPoland\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity()
 * @ORM\Table(name=Parcel::TABLE_NAME)
 */
class Parcel
{
    /**
     * @internal
     */
    public const TABLE_NAME = _DB_PREFIX_ . 'gls_poland_parcel';

    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=Consignment::class, inversedBy="parcels")
     * @ORM\JoinColumn(nullable=false)
     */
    private $consignment;

    /**
     * @ORM\Column(type="string", length=11, nullable=true)
     */
    private $number;

    /**
     * @ORM\Column(type="string", length=25, nullable=true)
     */
    private $reference;

    /**
     * @ORM\Column(type="float")
     */
    private $weight;

    public function __construct(float $weightKg, ?string $reference = null)
    {
        $this->weight = $weightKg;
        $this->reference = $reference;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getConsignment(): ?Consignment
    {
        return $this->consignment;
    }

    public function setConsignment(Consignment $consignment): self
    {
        if (null !== $this->consignment || null !== $consignment->getId()) {
            throw new \LogicException('Parcel cannot be moved between consignments.');
        }

        $this->consignment = $consignment;

        return $this;
    }

    public function getNumber(): ?string
    {
        return $this->number;
    }

    public function setNumber(string $number): self
    {
        if (null !== $this->number) {
            throw new \LogicException('Parcel already has a number assigned.');
        }

        $this->number = $number;

        return $this;
    }

    public function getReference(): ?string
    {
        return $this->reference;
    }

    public function getWeightKg(): float
    {
        return $this->weight;
    }
}
