<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Configuration\Initializer;

use Twig\Environment;
use Twig\Extension\ExtensionInterface;

final class TwigExtensionsInitializer implements ConfigurationInitializerInterface
{
    /**
     * @var Environment
     */
    private $twig;

    /**
     * @var iterable<ExtensionInterface>
     */
    private $extensions;

    /**
     * @param iterable<ExtensionInterface> $extensions
     */
    public function __construct(Environment $twig, iterable $extensions)
    {
        $this->twig = $twig;
        $this->extensions = $extensions;
    }

    public function init(): void
    {
        foreach ($this->extensions as $extension) {
            $this->twig->addExtension($extension);
        }
    }
}
