<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Configuration\Initializer;

use Doctrine\ORM\EntityManagerInterface;
use Gls\GlsPoland\Configuration\Api;
use Gls\GlsPoland\Doctrine\ORM\Query\SandboxFilter;

final class DoctrineFiltersInitializer implements ConfigurationInitializerInterface
{
    private const SANDBOX_FILTER_NAME = 'gls_poland_consignment_sandbox';

    private $entityManager;
    private $configuration;

    public function __construct(EntityManagerInterface $entityManager, Api\ConfigurationInterface $configuration)
    {
        $this->entityManager = $entityManager;
        $this->configuration = $configuration;
    }

    public function init(): void
    {
        $this->entityManager
            ->getConfiguration()
            ->addFilter(self::SANDBOX_FILTER_NAME, SandboxFilter::class);

        $this->entityManager
            ->getFilters()
            ->enable(self::SANDBOX_FILTER_NAME)
            ->setParameter('sandbox', $this->configuration->isSandboxEnabled());
    }
}
