<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Carrier\DTO;

use Gls\GlsPoland\Carrier\TimeDefiniteService;
use Symfony\Component\Validator\Constraints as Assert;

class AdditionalServices
{
    /**
     * @var bool|null
     *
     * @Assert\NotNull()
     */
    private $cashOnDelivery;

    /**
     * @var bool|null
     *
     * @Assert\NotNull()
     */
    private $documentReturn;

    /**
     * @var bool|null
     *
     * @Assert\NotNull()
     */
    private $saturdayDelivery;

    /**
     * @var TimeDefiniteService|null
     */
    private $timeDefiniteService;

    public function __construct(bool $cashOnDelivery = false, bool $documentReturn = false, bool $saturdayDelivery = false, ?TimeDefiniteService $timeDefiniteService = null)
    {
        $this->cashOnDelivery = $cashOnDelivery;
        $this->documentReturn = $documentReturn;
        $this->saturdayDelivery = $saturdayDelivery;
        $this->timeDefiniteService = $timeDefiniteService;
    }

    public function isCashOnDelivery(): ?bool
    {
        return $this->cashOnDelivery;
    }

    public function setCashOnDelivery(?bool $cashOnDelivery): self
    {
        $this->cashOnDelivery = $cashOnDelivery;

        return $this;
    }

    public function isDocumentReturn(): ?bool
    {
        return $this->documentReturn;
    }

    public function setDocumentReturn(?bool $documentReturn): self
    {
        $this->documentReturn = $documentReturn;

        return $this;
    }

    public function isSaturdayDelivery(): ?bool
    {
        return $this->saturdayDelivery;
    }

    public function setSaturdayDelivery(?bool $saturdayDelivery): self
    {
        $this->saturdayDelivery = $saturdayDelivery;

        return $this;
    }

    public function getTimeDefiniteService(): ?TimeDefiniteService
    {
        return $this->timeDefiniteService;
    }

    public function setTimeDefiniteService(?TimeDefiniteService $service): self
    {
        $this->timeDefiniteService = $service;

        return $this;
    }

    public function isDeliveryBefore10(): bool
    {
        return TimeDefiniteService::DELIVERY_BEFORE_10 === (string) $this->timeDefiniteService;
    }

    public function isDeliveryBefore12(): bool
    {
        return TimeDefiniteService::DELIVERY_BEFORE_12 === (string) $this->timeDefiniteService;
    }
}
