<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\PreparingBox;

use Gls\GlsPoland\AdePlus\Authorization\AuthorizedRequest;

class DeleteConsignment extends AuthorizedRequest
{
    /**
     * @var int
     */
    private $id;

    public function __construct(int $id)
    {
        $this->id = $id;
    }

    public function jsonSerialize(): array
    {
        return [
            'id' => $this->id,
        ];
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function withId(int $id): DeleteConsignment
    {
        $new = clone $this;
        $new->id = $id;

        return $new;
    }
}
