<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\PreparingBox;

use Gls\GlsPoland\AdePlus\Client as AdePlusClient;
use Gls\GlsPoland\AdePlus\Common\Id;
use Gls\GlsPoland\AdePlus\Consignment\Consignment;
use Gls\GlsPoland\AdePlus\Printout\Labels;
use Gls\GlsPoland\AdePlus\Printout\LabelsCollection;
use Gls\GlsPoland\AdePlus\Printout\LabelsPrintMode;

final class Client implements ClientInterface
{
    private $client;

    public function __construct(AdePlusClient $client)
    {
        $this->client = $client;
    }

    public function addConsignment(Consignment $consignment): Id
    {
        $params = new Insert($consignment);

        return $this->client->preparingBoxInsert($params);
    }

    public function deleteConsignment(int $id): Id
    {
        $params = new DeleteConsignment($id);

        return $this->client->preparingBoxDeleteConsignment($params);
    }

    public function isSandbox(): bool
    {
        return $this->client->isSandbox();
    }

    public function getConsignment(int $id): Consignment
    {
        $params = new GetConsignment($id);

        return $this->client->preparingBoxGetConsignment($params);
    }

    public function getLabels(int $consignmentId, LabelsPrintMode $printMode): Labels
    {
        $params = new GetConsignmentLabels($consignmentId, $printMode);

        return $this->client->preparingBoxGetConsignmentLabels($params);
    }

    public function getSeparateLabels(int $consignmentId, LabelsPrintMode $printMode): LabelsCollection
    {
        $params = new GetConsignmentLabelsExt($consignmentId, $printMode);

        return $this->client->preparingBoxGetConsignmentLabelsExt($params);
    }
}
