<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus;

use Gls\GlsPoland\Soap\ExtSoapEngine\Configuration\ClassMap\ClassMap;
use Gls\GlsPoland\Soap\ExtSoapEngine\Configuration\ClassMap\ClassMapCollection;

class ClassMapFactory
{
    public static function getCollection(): ClassMapCollection
    {
        return new ClassMapCollection(
            new ClassMap('cSession', Authorization\Session::class),
            new ClassMap('cConsign', Consignment\Consignment::class),
            new ClassMap('cSenderAddress', SenderAddress\SenderAddress::class),
            new ClassMap('cServicesBool', Common\Services::class),
            new ClassMap('cServiceDAW', Consignment\DAWOptions::class),
            new ClassMap('cServiceIDENT', Consignment\IDENTOptions::class),
            new ClassMap('cServicePPE', Consignment\PPEOptions::class),
            new ClassMap('cServiceSDS', Consignment\SDSOptions::class),
            new ClassMap('cParcelsArray', Consignment\ParcelsCollection::class),
            new ClassMap('cParcel', Consignment\Parcel::class),
            new ClassMap('cID', Common\Id::class),
            new ClassMap('cConsignsIDsArray', Consignment\ConsignmentIdsCollection::class),
            new ClassMap('cLabels', Printout\Labels::class),
            new ClassMap('cLabelsArray', Printout\LabelsCollection::class),
            new ClassMap('cLabel', Printout\Label::class),
            new ClassMap('cConsignBindIDsArray', Pickup\ConsignmentIdsBindingsCollection::class),
            new ClassMap('cConsignBindIDs', Pickup\ConsignmentIdsBinding::class),
            new ClassMap('cReceipt', Printout\PickupReceipt::class),
            new ClassMap('cStringArray', Common\StringArray::class),
            new ClassMap('cStatus', SenderAddress\SenderAddressStatus::class),
            new ClassMap('cSenderAddressArray', SenderAddress\SenderAddressesCollection::class),
            new ClassMap('cServices', Services\Services::class),
            new ClassMap('cCODMax', Services\MaxCODAmount::class),
            new ClassMap('cParcelWeightsMax', Services\MaxParcelWeights::class),
            new ClassMap('cParcelShop', ParcelShop\ParcelShop::class),
            new ClassMap('adeLoginIntegrator', Authorization\LoginIntegrator::class),
            new ClassMap('adeLoginIntegratorResponse', Authorization\LoginIntegratorResponse::class),
            new ClassMap('adeLogout', Authorization\Logout::class),
            new ClassMap('adeLogoutResponse', Authorization\LogoutResponse::class),
            new ClassMap('adePreparingBox_Insert', PreparingBox\Insert::class),
            new ClassMap('adePreparingBox_InsertResponse', PreparingBox\InsertResponse::class),
            new ClassMap('adePreparingBox_DeleteConsign', PreparingBox\DeleteConsignment::class),
            new ClassMap('adePreparingBox_DeleteConsignResponse', PreparingBox\DeleteConsignmentResponse::class),
            new ClassMap('adePreparingBox_GetConsign', PreparingBox\GetConsignment::class),
            new ClassMap('adePreparingBox_GetConsignResponse', PreparingBox\GetConsignmentResponse::class),
            new ClassMap('adePreparingBox_GetConsignLabels', PreparingBox\GetConsignmentLabels::class),
            new ClassMap('adePreparingBox_GetConsignLabelsResponse', PreparingBox\GetConsignmentLabelsResponse::class),
            new ClassMap('adePreparingBox_GetConsignLabelsExt', PreparingBox\GetConsignmentLabelsExt::class),
            new ClassMap('adePreparingBox_GetConsignLabelsExtResponse', PreparingBox\GetConsignmentLabelsExtResponse::class),
            new ClassMap('adePickup_Create', Pickup\Create::class),
            new ClassMap('adePickup_CreateResponse', Pickup\CreateResponse::class),
            new ClassMap('adePickup_GetConsignBinds', Pickup\GetConsignmentBindings::class),
            new ClassMap('adePickup_GetConsignBindsResponse', Pickup\GetConsignmentBindingsResponse::class),
            new ClassMap('adePickup_GetConsign', Pickup\GetConsignment::class),
            new ClassMap('adePickup_GetConsignResponse', Pickup\GetConsignmentResponse::class),
            new ClassMap('adePickup_GetReceipt', Pickup\GetReceipt::class),
            new ClassMap('adePickup_GetReceiptResponse', Pickup\GetReceiptResponse::class),
            new ClassMap('adePickup_GetConsignLabels', Pickup\GetConsignmentLabels::class),
            new ClassMap('adePickup_GetConsignLabelsResponse', Pickup\GetConsignmentLabelsResponse::class),
            new ClassMap('adePickup_GetConsignLabelsExt', Pickup\GetConsignmentLabelsExt::class),
            new ClassMap('adePickup_GetConsignLabelsExtResponse', Pickup\GetConsignmentLabelsExtResponse::class),
            new ClassMap('adeSendAddr_GetStatus', SenderAddress\GetStatus::class),
            new ClassMap('adeSendAddr_GetStatusResponse', SenderAddress\GetStatusResponse::class),
            new ClassMap('adeSendAddr_GetDictionary', SenderAddress\GetDictionary::class),
            new ClassMap('adeSendAddr_GetDictionaryResponse', SenderAddress\GetDictionaryResponse::class),
            new ClassMap('adeServices_GetAllowed', Services\GetAllowed::class),
            new ClassMap('adeServices_GetAllowedResponse', Services\GetAllowedResponse::class),
            new ClassMap('adeServices_GetMaxCOD', Services\GetMaxCOD::class),
            new ClassMap('adeServices_GetMaxCODResponse', Services\GetMaxCODResponse::class),
            new ClassMap('adeServices_GetMaxParcelWeights', Services\GetMaxParcelWeights::class),
            new ClassMap('adeServices_GetMaxParcelWeightsResponse', Services\GetMaxParcelWeightsResponse::class),
            new ClassMap('adeServices_GetGuaranteed', Services\GetGuaranteed::class),
            new ClassMap('adeServices_GetGuaranteedResponse', Services\GetGuaranteedResponse::class),
            new ClassMap('adeServices_GetCountriesSDS', Services\GetCountriesSDS::class),
            new ClassMap('adeServices_GetCountriesSDSResponse', Services\GetCountriesSDSResponse::class),
            new ClassMap('adeServices_GetCountriesSRS', Services\GetCountriesSRS::class),
            new ClassMap('adeServices_GetCountriesSRSResponse', Services\GetCountriesSRSResponse::class),
            new ClassMap('adeParcelShop_SearchByID', ParcelShop\SearchById::class),
            new ClassMap('adeParcelShop_SearchByIDResponse', ParcelShop\SearchByIdResponse::class)
        );
    }
}
