<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Authorization;

use Gls\GlsPoland\Soap\Client\Type\RequestInterface;

abstract class AuthorizedRequest implements RequestInterface, \JsonSerializable
{
    /**
     * @var string
     */
    protected $session;

    final public function getSession(): ?string
    {
        return $this->session;
    }

    /**
     * @return static
     */
    final public function withSession(string $session): self
    {
        $new = clone $this;
        $new->session = $session;

        return $new;
    }

    final public function __debugInfo(): array
    {
        return $this->jsonSerialize();
    }
}
