<?php

declare(strict_types=1);

use Gls\GlsPoland\PrestaShop\Checkout\CheckoutInterface;
use Gls\GlsPoland\PrestaShop\Checkout\CheckoutResolver;
use Symfony\Component\DependencyInjection\Argument\ServiceLocatorArgument;
use Symfony\Component\DependencyInjection\Argument\TaggedIteratorArgument;
use Symfony\Component\DependencyInjection\ContainerBuilder;

if (!defined('_PS_VERSION_') || Tools::version_compare(_PS_VERSION_, '8.0.0')) {
    return;
}

assert(isset($container) && $container instanceof ContainerBuilder);

$container
    ->registerForAutoconfiguration(CheckoutInterface::class)
    ->addTag('gls_poland.checkout')
    ->addTag('container.do_not_inline'); // needed to keep factory methods with return type declarations

$container->removeDefinition('gls_poland.checkout_locator');
$container
    ->getDefinition(CheckoutResolver::class)
    ->setArgument(0, new ServiceLocatorArgument(new TaggedIteratorArgument('gls_poland.checkout', null, 'getModuleName', true)));
